/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.framework.entity.sync;

import com.mrcrayfish.framework.api.sync.SyncedClassKey;
import com.mrcrayfish.framework.api.sync.SyncedDataKey;
import com.mrcrayfish.framework.entity.sync.DataEntry;
import com.mrcrayfish.framework.entity.sync.SyncedEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;

public class DataHolder {
    Map<SyncedDataKey<?, ?>, DataEntry<?, ?>> dataMap = new HashMap();
    private boolean dirty = false;

    <E extends Entity, T> boolean set(E entity, SyncedDataKey<?, ?> key, T value) {
        DataEntry entry = this.dataMap.computeIfAbsent(key, DataEntry::new);
        if (!entry.getValue().equals(value)) {
            boolean dirty = !entity.f_19853_.m_5776_() && entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE;
            entry.setValue(value, dirty);
            this.dirty = dirty;
            return true;
        }
        return false;
    }

    @Nullable
    <E extends Entity, T> T get(SyncedDataKey<E, T> key) {
        return this.dataMap.computeIfAbsent(key, DataEntry::new).getValue();
    }

    boolean isDirty() {
        return this.dirty;
    }

    void clean() {
        this.dirty = false;
        this.dataMap.forEach((key, entry) -> entry.clean());
    }

    List<DataEntry<?, ?>> gatherDirty() {
        return this.dataMap.values().stream().filter(DataEntry::isDirty).filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    List<DataEntry<?, ?>> gatherAll() {
        return this.dataMap.values().stream().filter(entry -> entry.getKey().syncMode() != SyncedDataKey.SyncMode.NONE).collect(Collectors.toList());
    }

    public ListTag serialize() {
        ListTag list = new ListTag();
        this.dataMap.forEach((key, entry) -> {
            if (key.save()) {
                CompoundTag keyTag = new CompoundTag();
                keyTag.m_128359_("ClassKey", key.classKey().id().toString());
                keyTag.m_128359_("DataKey", key.id().toString());
                keyTag.m_128365_("Value", entry.writeValue());
                list.add((Object)keyTag);
            }
        });
        return list;
    }

    public void deserialize(ListTag listTag) {
        this.dataMap.clear();
        listTag.forEach(entryTag -> {
            CompoundTag keyTag = (CompoundTag)entryTag;
            ResourceLocation classKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("ClassKey"));
            ResourceLocation dataKey = ResourceLocation.m_135820_((String)keyTag.m_128461_("DataKey"));
            Tag value = keyTag.m_128423_("Value");
            SyncedClassKey<?> syncedClassKey = SyncedEntityData.instance().getClassKey(classKey);
            if (syncedClassKey == null) {
                return;
            }
            Map<ResourceLocation, SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getDataKeys(syncedClassKey);
            if (keys == null) {
                return;
            }
            SyncedDataKey<?, ?> syncedDataKey = keys.get(dataKey);
            if (syncedDataKey == null || !syncedDataKey.save()) {
                return;
            }
            DataEntry entry = new DataEntry(syncedDataKey);
            entry.readValue(value);
            this.dataMap.put(syncedDataKey, entry);
        });
    }
}

