/*
 * Decompiled with CFR 0.152.
 */
package com.klikli_dev.modonomicon.api.datagen;

import com.mojang.logging.LogUtils;
import java.util.Arrays;
import net.minecraft.world.phys.Vec2;
import org.slf4j.Logger;

public class EntryLocationHelper {
    public static final Logger LOGGER = LogUtils.getLogger();
    protected String[] map;
    protected Vec2 offset;

    public void setMap(String ... map) {
        this.map = (String[])Arrays.stream(map).map(s -> s.replaceAll("\\s", "")).toArray(String[]::new);
        this.offset = new Vec2((float)(-((int)((float)map[0].length() / 2.0f))), (float)(-((int)((float)map.length / 2.0f))));
    }

    public void setOffset(Vec2 offset) {
        this.offset = offset;
    }

    public Vec2 get(Character symbol) {
        int y = 0;
        for (String line : this.map) {
            int x = 0;
            boolean inBracket = false;
            for (char c : line.toCharArray()) {
                if (c == symbol.charValue() && !inBracket) {
                    return new Vec2((float)x, (float)y).m_165910_(this.offset);
                }
                if (c == '(') {
                    inBracket = true;
                    continue;
                }
                if (c == ')') {
                    inBracket = false;
                    ++x;
                    continue;
                }
                if (inBracket) continue;
                ++x;
            }
            ++y;
        }
        LOGGER.warn("Symbol '{}' not found in map", (Object)symbol);
        return Vec2.f_82462_;
    }

    public Vec2 get(String symbol) {
        symbol = symbol.replace("(", "");
        symbol = symbol.replace(")", "");
        int y = 0;
        for (String line : this.map) {
            int x = 0;
            boolean inBracket = false;
            Object currentSymbol = "";
            for (char c : line.toCharArray()) {
                if (c == '(') {
                    inBracket = true;
                    continue;
                }
                if (c == ')') {
                    inBracket = false;
                    if (((String)currentSymbol).equals(symbol)) {
                        return new Vec2((float)x, (float)y).m_165910_(this.offset);
                    }
                    ++x;
                    currentSymbol = "";
                    continue;
                }
                if (inBracket) {
                    currentSymbol = (String)currentSymbol + c;
                    continue;
                }
                ++x;
            }
            ++y;
        }
        LOGGER.warn("Symbol '({})' not found in map", (Object)symbol);
        return Vec2.f_82462_;
    }
}

