/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.client;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.latvian.mods.kubejs.KubeJS;
import dev.latvian.mods.kubejs.KubeJSPaths;
import dev.latvian.mods.kubejs.bindings.event.ClientEvents;
import dev.latvian.mods.kubejs.client.GenerateClientAssetsEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.kubejs.script.ScriptType;
import dev.latvian.mods.kubejs.script.data.GeneratedResourcePack;
import dev.latvian.mods.kubejs.script.data.KubeJSFolderPackResources;
import dev.latvian.mods.kubejs.util.KubeJSPlugins;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.FilePackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;

public class GeneratedClientResourcePack
extends GeneratedResourcePack {
    public static List<PackResources> inject(List<PackResources> packs) {
        if (KubeJS.instance != null) {
            packs = new ArrayList<PackResources>(packs);
            int i = packs.size();
            for (int j = 1; j < packs.size(); ++j) {
                if (!(packs.get(j) instanceof FilePackResources)) continue;
                i = j;
                break;
            }
            ArrayList<Object> injected = new ArrayList<Object>(2);
            injected.add(new GeneratedClientResourcePack());
            injected.add((Object)KubeJSFolderPackResources.PACK);
            for (File file : Objects.requireNonNull(KubeJSPaths.ASSETS.toFile().listFiles())) {
                if (!file.isFile() || !file.getName().endsWith(".zip")) continue;
                injected.add(new FilePackResources(file));
            }
            packs.addAll(i, injected);
        }
        return packs;
    }

    public GeneratedClientResourcePack() {
        super(PackType.CLIENT_RESOURCES);
    }

    @Override
    public void generate(Map<ResourceLocation, byte[]> map) {
        AssetJsonGenerator generator = new AssetJsonGenerator(map);
        KubeJSPlugins.forEachPlugin(p -> p.generateAssetJsons(generator));
        HashMap<String, String> langMap = new HashMap<String, String>();
        KubeJSPlugins.forEachPlugin(p -> p.generateLang(langMap));
        ClientEvents.HIGH_ASSETS.post(ScriptType.CLIENT, new GenerateClientAssetsEventJS(generator, langMap));
        JsonObject lang = new JsonObject();
        for (Map.Entry<String, String> entry : langMap.entrySet()) {
            lang.addProperty(entry.getKey(), entry.getValue());
        }
        generator.json(new ResourceLocation("kubejs_generated:lang/en_us"), (JsonElement)lang);
    }
}

