/*
 * Decompiled with CFR 0.152.
 */
package vazkii.patchouli.client.book;

import com.google.common.base.Preconditions;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import org.jetbrains.annotations.Nullable;
import vazkii.patchouli.api.PatchouliAPI;
import vazkii.patchouli.client.book.BookContentLoader;
import vazkii.patchouli.common.book.Book;

public final class BookContentResourceDirectLoader
implements BookContentLoader {
    public static final BookContentResourceDirectLoader INSTANCE = new BookContentResourceDirectLoader();

    private BookContentResourceDirectLoader() {
    }

    @Override
    public void findFiles(Book book, String dir, List<ResourceLocation> list) {
        String prefix = String.format("%s/%s/%s/%s", "patchouli_books", book.id.m_135815_(), "en_us", dir);
        Set files = Minecraft.m_91087_().m_91098_().m_214159_(prefix, p -> p.m_135815_().endsWith(".json")).keySet();
        files.stream().distinct().filter(file -> file.m_135827_().equals(book.id.m_135827_())).map(file -> {
            Preconditions.checkArgument((boolean)file.m_135815_().startsWith(prefix));
            Preconditions.checkArgument((boolean)file.m_135815_().endsWith(".json"));
            String newPath = file.m_135815_().substring(prefix.length(), file.m_135815_().length() - ".json".length());
            if (newPath.startsWith("/")) {
                newPath = newPath.substring(1);
            }
            return new ResourceLocation(file.m_135827_(), newPath);
        }).forEach(list::add);
    }

    @Override
    @Nullable
    public JsonElement loadJson(Book book, ResourceLocation file, @Nullable ResourceLocation fallback) {
        PatchouliAPI.LOGGER.debug("Loading {}", (Object)file);
        ResourceManager manager = Minecraft.m_91087_().m_91098_();
        try {
            Optional resource = manager.m_213713_(file);
            if (resource.isPresent()) {
                return BookContentLoader.streamToJson(((Resource)resource.get()).m_215507_());
            }
            if (fallback != null && (resource = manager.m_213713_(fallback)).isPresent()) {
                return BookContentLoader.streamToJson(((Resource)resource.get()).m_215507_());
            }
            return null;
        }
        catch (IOException ex) {
            throw new UncheckedIOException(ex);
        }
    }
}

