/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.item;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.client.ClientStuff;
import xerca.xercapaint.common.item.Items;

public class ItemPalette
extends Item {
    ItemPalette() {
        super(new Item.Properties().m_41491_(Items.paintTab).m_41487_(1));
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(Level worldIn, @NotNull Player playerIn, @Nonnull InteractionHand hand) {
        if (worldIn.f_46443_) {
            ClientStuff.showCanvasGui(playerIn);
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)playerIn.m_21120_(hand));
    }

    @ParametersAreNonnullByDefault
    public void m_6787_(CreativeModeTab group, NonNullList<ItemStack> items) {
        if (this.m_220152_(group)) {
            items.add((Object)new ItemStack((ItemLike)this));
            ItemStack fullPalette = new ItemStack((ItemLike)this);
            byte[] basicColors = new byte[16];
            Arrays.fill(basicColors, (byte)1);
            fullPalette.m_41784_().m_128382_("basic", basicColors);
            items.add((Object)fullPalette);
        }
    }

    public static boolean isFull(ItemStack stack) {
        return ItemPalette.basicColorCount(stack) == 16;
    }

    public static int basicColorCount(ItemStack stack) {
        byte[] basicColors;
        if (stack.m_41720_() != Items.ITEM_PALETTE.get()) {
            return 0;
        }
        CompoundTag tag = stack.m_41783_();
        if (tag != null && tag.m_128441_("basic") && (basicColors = tag.m_128463_("basic")).length == 16) {
            int basicCount = 0;
            for (byte basicColor : basicColors) {
                basicCount += basicColor;
            }
            return basicCount;
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, @NotNull List<Component> tooltip, @NotNull TooltipFlag flagIn) {
        if (stack.m_41782_()) {
            CompoundTag tag = stack.m_41783_();
            if (tag != null) {
                int[] ns;
                byte[] basicColors = tag.m_128463_("basic");
                if (basicColors.length == 16) {
                    int basicCount = 0;
                    for (byte basicColor : basicColors) {
                        basicCount += basicColor;
                    }
                    tooltip.add((Component)Component.m_237110_((String)"palette.basic_count", (Object[])new Object[]{String.valueOf(basicCount)}).m_130940_(ChatFormatting.GRAY));
                }
                if ((ns = tag.m_128465_("n")).length == 12) {
                    int fullCount = 0;
                    for (int n : ns) {
                        if (n <= 0) continue;
                        ++fullCount;
                    }
                    tooltip.add((Component)Component.m_237110_((String)"palette.custom_count", (Object[])new Object[]{String.valueOf(fullCount)}).m_130940_(ChatFormatting.GRAY));
                }
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"palette.empty").m_130940_(ChatFormatting.GRAY));
        }
    }
}

