/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common.entity;

import javax.annotation.Nullable;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.network.NetworkHooks;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.PlayMessages;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.entity.Entities;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.item.ItemPalette;
import xerca.xercapaint.common.item.Items;
import xerca.xercapaint.common.packets.CloseGuiPacket;
import xerca.xercapaint.common.packets.OpenGuiPacket;

public class EntityEasel
extends Entity {
    private static final EntityDataAccessor<ItemStack> DATA_CANVAS = SynchedEntityData.m_135353_(EntityEasel.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private Player painter = null;
    private Runnable dropDeferred = null;
    private int dropWaitTicks = 0;

    public EntityEasel(Level world) {
        super((EntityType)Entities.EASEL.get(), world);
    }

    public EntityEasel(EntityType<EntityEasel> entityCanvasEntityType, Level world) {
        super(entityCanvasEntityType, world);
    }

    public EntityEasel(PlayMessages.SpawnEntity ignoredSpawnEntity, Level world) {
        super((EntityType)Entities.EASEL.get(), world);
    }

    public void setPainter(Player painter) {
        this.painter = painter;
    }

    public boolean m_6094_() {
        return false;
    }

    public boolean m_6469_(@NotNull DamageSource damageSource, float pAmount) {
        if (!this.f_19853_.f_46443_ && !this.m_213877_()) {
            if (!this.getItem().m_41619_() && !damageSource.m_19372_()) {
                this.dropItem(damageSource.m_7639_(), false);
            } else {
                this.dropItem(damageSource.m_7639_());
                this.m_6074_();
            }
        }
        return false;
    }

    private void showBreakingParticles() {
        if (this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, Blocks.f_50742_.m_49966_()), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    public void m_6074_() {
        this.showBreakingParticles();
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(DATA_CANVAS, (Object)ItemStack.f_41583_);
    }

    public void dropItem(@Nullable Entity entity) {
        this.dropItem(entity, true);
    }

    private void dropItem(@Nullable Entity entity, boolean dropSelf) {
        if (this.painter != null) {
            if (!this.f_19853_.f_46443_ && this.dropDeferred == null) {
                CloseGuiPacket pack = new CloseGuiPacket();
                XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.painter), (Object)pack);
                this.dropDeferred = () -> this.doDrop(entity, dropSelf);
            }
        } else {
            this.doDrop(entity, dropSelf);
        }
    }

    public void doDrop(@Nullable Entity entity, boolean dropSelf) {
        ItemStack canvasStack = this.getItem();
        this.setItem(ItemStack.f_41583_);
        if (!canvasStack.m_41619_()) {
            canvasStack = canvasStack.m_41777_();
            this.m_19983_(canvasStack);
        }
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (player.m_150110_().f_35937_) {
                return;
            }
        }
        if (dropSelf && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
            this.m_19983_(this.getEaselItemStack());
        }
    }

    public ItemStack getItem() {
        return (ItemStack)this.m_20088_().m_135370_(DATA_CANVAS);
    }

    public void setItem(ItemStack itemStack) {
        this.setItem(itemStack, true);
    }

    public void setItem(ItemStack itemStack, boolean makeSound) {
        if (!itemStack.m_41619_()) {
            itemStack = itemStack.m_41777_();
            itemStack.m_41764_(1);
            itemStack.m_41636_((Entity)this);
        }
        this.m_20088_().m_135381_(DATA_CANVAS, (Object)itemStack);
        if (makeSound) {
            if (!itemStack.m_41619_()) {
                this.m_5496_(SoundEvents.f_12176_, 1.0f, 1.0f);
            } else {
                this.m_5496_(SoundEvents.f_12175_, 1.0f, 1.0f);
            }
        }
    }

    @NotNull
    public SlotAccess m_141942_(int i) {
        return i == 0 ? new SlotAccess(){

            @NotNull
            public ItemStack m_142196_() {
                return EntityEasel.this.getItem();
            }

            public boolean m_142104_(@NotNull ItemStack itemStack) {
                EntityEasel.this.setItem(itemStack);
                return true;
            }
        } : super.m_141942_(i);
    }

    @NotNull
    public Packet<?> m_5654_() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> accessor) {
        ItemStack itemStack;
        super.m_7350_(accessor);
        if (accessor.equals(DATA_CANVAS) && !(itemStack = this.getItem()).m_41619_() && itemStack.m_41609_() != this) {
            itemStack.m_41636_((Entity)this);
        }
    }

    public void m_7380_(@NotNull CompoundTag tag) {
        if (!this.getItem().m_41619_()) {
            tag.m_128365_("Item", (Tag)this.getItem().m_41739_(new CompoundTag()));
        }
    }

    public void m_7378_(CompoundTag tag) {
        CompoundTag itemTag = tag.m_128469_("Item");
        if (!itemTag.m_128456_()) {
            ItemStack var3 = ItemStack.m_41712_((CompoundTag)itemTag);
            if (var3.m_41619_()) {
                XercaPaint.LOGGER.warn("Unable to load item from: {}", (Object)itemTag);
            }
            this.setItem(var3, false);
        }
    }

    @NotNull
    public InteractionResult m_6096_(Player player, @NotNull InteractionHand hand) {
        ItemStack itemInHand = player.m_21120_(hand);
        boolean isEaselFilled = !this.getItem().m_41619_();
        boolean handHoldsCanvas = itemInHand.m_41720_() instanceof ItemCanvas;
        boolean handHoldsPalette = itemInHand.m_41720_() instanceof ItemPalette;
        if (this.f_19853_.f_46443_) {
            return !isEaselFilled && !handHoldsCanvas ? InteractionResult.PASS : InteractionResult.SUCCESS;
        }
        if (!isEaselFilled) {
            if (handHoldsCanvas && !this.m_213877_()) {
                this.setItem(itemInHand);
                itemInHand.m_41774_(1);
            }
        } else {
            boolean unused = this.painter == null;
            boolean toEdit = handHoldsPalette && (!this.getItem().m_41782_() || this.getItem().m_41783_() == null || this.getItem().m_41783_().m_128451_("generation") <= 0);
            boolean allowed = unused || !toEdit;
            OpenGuiPacket pack = new OpenGuiPacket(this.m_19879_(), allowed, toEdit, hand);
            XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)player), (Object)pack);
            if (toEdit && allowed) {
                this.painter = player;
            }
        }
        return InteractionResult.CONSUME;
    }

    protected ItemStack getEaselItemStack() {
        return new ItemStack((ItemLike)Items.ITEM_EASEL.get());
    }

    public ItemStack m_142340_() {
        ItemStack canvas = this.getItem();
        return canvas.m_41619_() ? this.getEaselItemStack() : canvas.m_41777_();
    }

    public void m_8119_() {
        super.m_8119_();
        this.m_6478_(MoverType.SELF, new Vec3(0.0, -0.25, 0.0));
        this.m_20090_();
        if (!this.f_19853_.f_46443_ && this.dropDeferred != null) {
            ++this.dropWaitTicks;
            if (this.painter == null || this.dropWaitTicks > 80) {
                this.dropDeferred.run();
                this.dropDeferred = null;
                this.dropWaitTicks = 0;
            }
        }
        if (this.painter != null) {
            if (this.painter.m_213877_() || !this.painter.m_6084_()) {
                this.painter = null;
            } else if (this.painter.m_20280_((Entity)this) > 64.0) {
                this.painter = null;
            }
        }
    }

    public boolean m_6087_() {
        return true;
    }

    public void m_8061_(@NotNull EquipmentSlot equipmentSlot, @NotNull ItemStack itemStack) {
    }
}

