/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.common;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.io.IOException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.network.PacketDistributor;
import xerca.xercapaint.common.XercaPaint;
import xerca.xercapaint.common.item.ItemCanvas;
import xerca.xercapaint.common.packets.ExportPaintingPacket;

public class CommandExport {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"paintexport").requires(p -> p.m_6761_(1))).then(Commands.m_82129_((String)"name", (ArgumentType)StringArgumentType.word()).executes(p -> CommandExport.paintExport((CommandSourceStack)p.getSource(), StringArgumentType.getString((CommandContext)p, (String)"name")))));
    }

    private static int paintExport(CommandSourceStack stack, String name) {
        XercaPaint.LOGGER.debug("Paint export called. name: " + name);
        if (stack.m_81373_() == null) {
            XercaPaint.LOGGER.error("Command entity is not found");
            return 0;
        }
        Entity commander = stack.m_81373_();
        if (!(commander instanceof ServerPlayer)) {
            XercaPaint.LOGGER.error("Command entity is not a player");
            return 0;
        }
        ServerPlayer player = (ServerPlayer)commander;
        ExportPaintingPacket pack = new ExportPaintingPacket(name);
        XercaPaint.NETWORK_HANDLER.send(PacketDistributor.PLAYER.with(() -> player), (Object)pack);
        return 1;
    }

    public static boolean doExport(Player player, String name) {
        String dir = "paintings";
        String filename = name + ".paint";
        String filepath = dir + "/" + filename;
        File directory = new File(dir);
        if (!directory.exists()) {
            directory.mkdir();
        }
        for (ItemStack s : player.m_6167_()) {
            if (!(s.m_41720_() instanceof ItemCanvas) || !s.m_41782_() || s.m_41783_() == null) continue;
            try {
                CompoundTag tag = s.m_41783_().m_6426_();
                tag.m_128344_("ct", (byte)((ItemCanvas)s.m_41720_()).getCanvasType().ordinal());
                NbtIo.m_128955_((CompoundTag)tag, (File)new File(filepath));
                return true;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return false;
    }
}

