/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercapaint.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import xerca.xercapaint.common.CanvasType;
import xerca.xercapaint.common.entity.EntityEasel;

@OnlyIn(value=Dist.CLIENT)
public class GuiCanvasView
extends Screen {
    private int canvasX;
    private int canvasY = 40;
    private final int canvasWidth;
    private final int canvasPixelScale;
    private final int canvasPixelWidth;
    private final int canvasPixelHeight;
    private final CanvasType canvasType;
    private int[] pixels;
    private String authorName = "";
    private String canvasTitle = "";
    private int generation = 0;
    private final EntityEasel easel;
    private final Player player;

    protected GuiCanvasView(CompoundTag canvasTag, Component title, CanvasType canvasType, EntityEasel easel) {
        super(title);
        this.canvasType = canvasType;
        this.canvasPixelScale = canvasType == CanvasType.SMALL ? 10 : 5;
        this.canvasPixelWidth = CanvasType.getWidth(canvasType);
        this.canvasPixelHeight = CanvasType.getHeight(canvasType);
        int canvasPixelArea = this.canvasPixelHeight * this.canvasPixelWidth;
        this.canvasWidth = this.canvasPixelWidth * this.canvasPixelScale;
        this.easel = easel;
        this.player = Minecraft.m_91087_().f_91074_;
        if (canvasTag != null && !canvasTag.m_128456_()) {
            int[] nbtPixels = canvasTag.m_128465_("pixels");
            this.authorName = canvasTag.m_128461_("author");
            this.canvasTitle = canvasTag.m_128461_("title");
            this.generation = canvasTag.m_128451_("generation");
            this.pixels = Arrays.copyOfRange(nbtPixels, 0, canvasPixelArea);
        }
    }

    public void m_7856_() {
        this.canvasX = (this.f_96543_ - this.canvasWidth) / 2;
        if (this.canvasType.equals((Object)CanvasType.LONG)) {
            this.canvasY += 40;
        }
    }

    private int getPixelAt(int x, int y) {
        return this.pixels == null ? -393218 : this.pixels[y * this.canvasPixelWidth + x];
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(@NotNull PoseStack matrixStack, int mouseX, int mouseY, float f) {
        for (int i = 0; i < this.canvasPixelHeight; ++i) {
            for (int j = 0; j < this.canvasPixelWidth; ++j) {
                int x = this.canvasX + j * this.canvasPixelScale;
                int y = this.canvasY + i * this.canvasPixelScale;
                GuiCanvasView.m_93172_((PoseStack)matrixStack, (int)x, (int)y, (int)(x + this.canvasPixelScale), (int)(y + this.canvasPixelScale), (int)this.getPixelAt(j, i));
            }
        }
        if (this.generation > 0 && !this.canvasTitle.isEmpty()) {
            String title = this.canvasTitle + " " + I18n.m_118938_((String)"canvas.byAuthor", (Object[])new Object[]{this.authorName});
            String gen = "(" + I18n.m_118938_((String)("canvas.generation." + (this.generation - 1)), (Object[])new Object[0]) + ")";
            int titleWidth = this.f_96547_.m_92895_(title);
            int genWidth = this.f_96547_.m_92895_(gen);
            float titleX = (float)this.canvasX + (float)(this.canvasWidth - titleWidth) / 2.0f;
            float genX = (float)this.canvasX + (float)(this.canvasWidth - genWidth) / 2.0f;
            float minX = Math.min(genX, titleX);
            float maxX = Math.max(genX + (float)genWidth, titleX + (float)titleWidth);
            GuiCanvasView.m_93172_((PoseStack)matrixStack, (int)((int)(minX - 10.0f)), (int)(this.canvasY - 30), (int)((int)(maxX + 10.0f)), (int)(this.canvasY - 4), (int)-1118482);
            this.f_96547_.m_92883_(matrixStack, title, titleX, (float)(this.canvasY - 25), -15658735);
            this.f_96547_.m_92883_(matrixStack, gen, genX, (float)(this.canvasY - 14), -12303292);
        }
    }

    public void m_86600_() {
        if (this.easel != null && (this.easel.getItem().m_41619_() || this.easel.m_213877_() || this.easel.m_20280_((Entity)this.player) > 64.0)) {
            this.m_7379_();
        }
        super.m_86600_();
    }
}

