/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.fluids.forge;

import java.util.List;
import javax.annotation.Nullable;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.api.fluids.VanillaSoftFluids;
import net.mehvahdjukaar.moonlight.api.util.PotionNBTHelper;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.client.SoftFluidClient;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class SoftFluidTankImpl
extends SoftFluidTank {
    public static SoftFluidTank create(int capacity) {
        return new SoftFluidTankImpl(capacity);
    }

    protected SoftFluidTankImpl(int capacity) {
        super(capacity);
    }

    public boolean isSameFluidAs(FluidStack fluidStack) {
        return this.isSameFluidAs(fluidStack, fluidStack.getTag());
    }

    public boolean isSameFluidAs(FluidStack fluidStack, CompoundTag com) {
        return this.fluid.isEquivalent(fluidStack.getFluid()) && SoftFluidTankImpl.areNbtEquals(com, this.nbt);
    }

    public boolean tryAddingFluid(FluidStack fluidStack) {
        int count = fluidStack.getAmount();
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(this.fluid.getForgeFluid());
        return this.tryAddingFluid(s, count, fluidStack.getTag());
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination, int bottles) {
        int fillableAmount;
        if (!this.canRemove(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack stack = this.toEquivalentForgeFluid(milliBuckets);
        if (!stack.isEmpty() && (fillableAmount = fluidDestination.fill(stack, IFluidHandler.FluidAction.SIMULATE)) == milliBuckets) {
            fluidDestination.fill(stack, IFluidHandler.FluidAction.EXECUTE);
            this.shrink(bottles);
            return true;
        }
        return false;
    }

    public boolean tryTransferToFluidTank(IFluidHandler fluidDestination) {
        return this.tryTransferToFluidTank(fluidDestination, 1);
    }

    public boolean drainFluidTank(IFluidHandler fluidSource, int bottles) {
        if (!this.canAdd(bottles)) {
            return false;
        }
        int milliBuckets = bottles * 250;
        FluidStack drainable = fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.SIMULATE);
        if (!drainable.isEmpty() && drainable.getAmount() == milliBuckets) {
            boolean transfer = false;
            CompoundTag fsTag = drainable.getTag();
            if (this.fluid.isEmpty()) {
                this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), fsTag);
                transfer = true;
            } else if (this.isSameFluidAs(drainable, fsTag)) {
                transfer = true;
            }
            if (transfer) {
                fluidSource.drain(milliBuckets, IFluidHandler.FluidAction.EXECUTE);
                this.grow(bottles);
                return true;
            }
        }
        return false;
    }

    public boolean drainFluidTank(IFluidHandler fluidSource) {
        return this.drainFluidTank(fluidSource, 1);
    }

    public FluidStack toEquivalentForgeFluid(int mb) {
        FluidStack stack = new FluidStack(this.fluid.getForgeFluid(), mb);
        this.applyNBTtoFluidStack(stack);
        return stack;
    }

    private void applyNBTtoFluidStack(FluidStack fluidStack) {
        List<String> nbtKey = this.fluid.getNbtKeyFromItem();
        if (this.nbt != null && !this.nbt.m_128456_() && !fluidStack.isEmpty() && nbtKey != null) {
            CompoundTag newCom = new CompoundTag();
            for (String k : nbtKey) {
                Tag c;
                if (k.equals("Bottle") && Utils.getID(fluidStack.getFluid()).m_135827_().equals("immersiveengineering") || (c = this.nbt.m_128423_(k)) == null) continue;
                newCom.m_128365_(k, c);
            }
            if (!newCom.m_128456_()) {
                fluidStack.setTag(newCom);
            }
        }
    }

    public void copy(IFluidHandler other) {
        FluidStack drainable = other.getFluidInTank(0).copy();
        CompoundTag nbt = drainable.isEmpty() ? null : drainable.getTag();
        this.setFluid(SoftFluidRegistry.fromForgeFluid(drainable.getFluid()), nbt);
        this.setCount(Math.min(this.capacity, other.getTankCapacity(0)));
    }

    public void fill(FluidStack fluidStack) {
        this.setFluid(fluidStack);
        this.fillCount();
    }

    public void setFluid(FluidStack fluidStack) {
        SoftFluid s = SoftFluidRegistry.fromForgeFluid(fluidStack.getFluid());
        this.setFluid(s, fluidStack.getTag());
    }

    @Override
    public int getTintColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.NO_TINT) {
            return -1;
        }
        if (this.needsColorRefresh) {
            this.refreshSpecialColor(world, pos);
            this.needsColorRefresh = false;
        }
        if (this.specialColor != 0) {
            return this.specialColor;
        }
        return this.fluid.getTintColor();
    }

    @Override
    public int getFlowingTint(@Nullable LevelReader world, @Nullable BlockPos pos) {
        SoftFluid.TintMethod method = this.fluid.getTintMethod();
        if (method == SoftFluid.TintMethod.FLOWING) {
            return this.getParticleColor(world, pos);
        }
        return this.getTintColor(world, pos);
    }

    @Override
    public int getParticleColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        if (this.isEmpty()) {
            return -1;
        }
        int tintColor = this.getTintColor(world, pos);
        if (tintColor == -1) {
            return SoftFluidClient.get(this.fluid);
        }
        return tintColor;
    }

    private void refreshSpecialColor(@Nullable LevelReader world, @Nullable BlockPos pos) {
        if (this.fluid == VanillaSoftFluids.POTION.get()) {
            this.specialColor = PotionNBTHelper.getColorFromNBT(this.nbt);
        } else {
            int w;
            IClientFluidTypeExtensions prop;
            Fluid f = this.fluid.getForgeFluid();
            if (f != Fluids.f_76191_ && (prop = IClientFluidTypeExtensions.of((Fluid)f)) != IClientFluidTypeExtensions.DEFAULT && (w = prop.getTintColor(this.toEquivalentForgeFluid(1))) != -1) {
                this.specialColor = w;
            }
        }
    }
}

